/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import minecrafttransportsimulator.jsondefs.AJSONBase;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSkin;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.packloading.PackParser;

public class PackResourceLoader {
    public static String getPackResource(AJSONItem definition, ResourceType type, String name) {
        switch (PackStructure.values()[PackParser.getPackConfiguration((String)definition.packID).fileStructure]) {
            case DEFAULT: {
                return "/assets/" + definition.packID + "/" + type.prefixFolder + definition.classification.toDirectory() + name + type.normalSuffix;
            }
            case LAYERED: {
                return "/assets/" + definition.packID + "/" + type.prefixFolder + definition.classification.toDirectory() + definition.prefixFolders + name + type.normalSuffix;
            }
            case MODULAR: {
                return "/assets/" + definition.packID + "/" + definition.classification.toDirectory() + definition.prefixFolders + name + type.modularSuffix;
            }
        }
        return null;
    }

    public static enum PackStructure {
        DEFAULT,
        LAYERED,
        MODULAR;

    }

    public static enum ResourceType {
        OBJ_MODEL("objmodels/", ".obj", ".obj"),
        LT_MODEL("littletilesmodels/", ".txt", ".txt"),
        PNG("textures/", ".png", ".png"),
        ITEM_PNG("textures/items/", ".png", "_item.png"),
        ITEM_JSON("models/item/", ".json", "_item.json");

        public final String prefixFolder;
        public final String normalSuffix;
        public final String modularSuffix;

        private ResourceType(String prefixFolder, String normalSuffix, String modularSuffix) {
            this.prefixFolder = prefixFolder;
            this.normalSuffix = normalSuffix;
            this.modularSuffix = modularSuffix;
        }
    }

    public static enum ItemClassification {
        VEHICLE(JSONVehicle.class),
        PART(JSONPart.class),
        INSTRUMENT(JSONInstrument.class),
        POLE(JSONPoleComponent.class),
        ROAD(JSONRoadComponent.class),
        DECOR(JSONDecor.class),
        BULLET(JSONBullet.class),
        ITEM(JSONItem.class),
        SKIN(JSONSkin.class),
        PANEL(JSONPanel.class);

        public final Class<? extends AJSONBase> representingClass;

        private ItemClassification(Class<? extends AJSONBase> representingClass) {
            this.representingClass = representingClass;
        }

        public static List<String> getAllTypesAsStrings() {
            ArrayList<String> assetTypes = new ArrayList<String>();
            for (ItemClassification classification : ItemClassification.values()) {
                assetTypes.add(classification.name().toLowerCase(Locale.ROOT));
            }
            return assetTypes;
        }

        public String toDirectory() {
            return this.name().toLowerCase(Locale.ROOT) + "s/";
        }

        public static ItemClassification fromDirectory(String directory) {
            try {
                return ItemClassification.valueOf(directory.substring(0, directory.length() - "s/".length()).toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Was told to get classification for directory: " + directory + " but none exists.  Contact the mod author!");
            }
        }
    }
}

